//this file is part of eMule
//Copyright (C)2002-2008 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PreferencesDlg.h"
#include "EnBitmap.h" //dlarge 
#include "EMF/ModName/Modname.h" //==> dlarge Modname

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#endif

IMPLEMENT_DYNAMIC(CPreferencesDlg, CPropertySheet)
//dlarge ModelessDialogs
//BEGIN_MESSAGE_MAP(CPreferencesDlg, CPropertySheet)
BEGIN_MESSAGE_MAP(CPreferencesDlg, CModPropertySheet)
//dlarge end
	ON_WM_DESTROY()
	ON_MESSAGE(WM_SBN_SELCHANGED, OnSlideBarSelChanged) //>>> WiZaRd::SlideBar [eMule+]
END_MESSAGE_MAP()

CPreferencesDlg::CPreferencesDlg()
{
	m_psh.dwFlags &= ~PSH_HASHELP;
	m_wndGeneral.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndDisplay.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndConnection.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndServer.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndDirectories.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndFiles.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndStats.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndMessages.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndWebServer.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndTweaks.m_psp.dwFlags &= ~PSH_HASHELP;
        m_wndHiddenprefs.m_psp.dwFlags &= ~PSH_HASHELP;     //dlarge Hidden prefs
	m_wndSecurity.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndScheduler.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndProxy.m_psp.dwFlags &= ~PSH_HASHELP;

//dlarge Mod Pages
	m_wndeMuleFuture.m_psp.dwFlags &= ~PSH_HASHELP; //Tweaks 1
	m_wndTweaks2.m_psp.dwFlags &= ~PSH_HASHELP;     //dlarge Tweaks 2
        m_wndX_General.m_psp.dwFlags &= ~PSH_HASHELP;   //dlarge Tweaks 3
	m_wndBackup.m_psp.dwFlags &= ~PSH_HASHELP;      //dlarge Backup
        m_wndVS.m_psp.dwFlags &= ~PSH_HASHELP;          //dlarge Virus Scan
	m_wndArgos.m_psp.dwFlags &= ~PSH_HASHELP;       //dlarge Argos
	m_wndUpdates.m_psp.dwFlags &= ~PSH_HASHELP;	//>>> shadow2004::Updates-Prefspage

//dlarge end

#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	m_wndDebug.m_psp.dwFlags &= ~PSH_HASHELP;
#endif

//>>> WiZaRd::SlideBar [eMule+]	
	EnableStackedTabs(FALSE);
//<<< WiZaRd::SlideBar [eMule+]

	AddPage(&m_wndGeneral);
	AddPage(&m_wndDisplay);
	AddPage(&m_wndConnection);
	AddPage(&m_wndServer);
	AddPage(&m_wndDirectories);
	AddPage(&m_wndFiles);
	AddPage(&m_wndProxy);
	AddPage(&m_wndNotify);
	AddPage(&m_wndStats);
	AddPage(&m_wndMessages);
	AddPage(&m_wndSecurity);
	AddPage(&m_wndScheduler);
	AddPage(&m_wndWebServer);
	AddPage(&m_wndTweaks);
	AddPage(&m_wndHiddenprefs); //dlarge Hidden Prefs
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	AddPage(&m_wndDebug);
#endif

	//dlarge Mod Pages
	AddPage(&m_wndeMuleFuture); //Tweaks 1
	AddPage(&m_wndTweaks2);     //Tweaks 2
        AddPage(&m_wndX_General);   //Tweaks 3
	AddPage(&m_wndBackup);      //dlarge Backup
        AddPage(&m_wndVS);          //dlarge Virus Scan
	AddPage(&m_wndArgos);        //dlarge Argos
	AddPage(&m_wndUpdates);	    //>>> shadow2004::Updates-Prefspage

//dlarge end

	m_nActiveWnd = 0;
	m_bSaveIniFile = false;
}

CPreferencesDlg::~CPreferencesDlg()
{
	m_ImageList.DeleteImageList(); //>>> WiZaRd::SlideBar [eMule+]
}

void CPreferencesDlg::OnDestroy()
{
	CPropertySheet::OnDestroy();

	if (m_bSaveIniFile){
		thePrefs.Save();
		m_bSaveIniFile = false;
	}

	m_nActiveWnd = GetActiveIndex();
}

BOOL CPreferencesDlg::OnInitDialog()
{
//>>> WiZaRd::SlideBar [eMule+]
	m_SlideBar.CreateEx(WS_EX_CLIENTEDGE, WS_CHILD | WS_VISIBLE | WS_BORDER, CRect(0, 0, 0, 0), this, IDC_PREFS_SLIDEBAR);
	m_SlideBar.SetImageList(&m_ImageList);
	m_SlideBar.SetHAlignCaption(DT_CENTER);

//	Sets a bold font for the group buttons
	CFont* pGroupFont = m_SlideBar.GetGroupFont();
	ASSERT_VALID(pGroupFont);
	LOGFONT logFont;
	pGroupFont->GetLogFont(&logFont);
	logFont.lfWeight *= 2;
	if (logFont.lfWeight > FW_BLACK)
		logFont.lfWeight = FW_BLACK;
	pGroupFont->DeleteObject();
	pGroupFont->CreateFontIndirect(&logFont);
	ASSERT_VALID(pGroupFont);
//<<< WiZaRd::SlideBar [eMule+]

	ASSERT(!m_bSaveIniFile);
//dlarge ModelessDialogs
//	BOOL bResult = CPropertySheet::OnInitDialog();
	BOOL bResult = CModPropertySheet::OnInitDialog();
//dlarge end

	SetActivePage(m_nActiveWnd);

//>>> Spike2::Prefs Side Banner [TPT]/dlarge changes
if(thePrefs.m_bSideBanner){
	CEnBitmap bmp;
	bmp.LoadImage(_T("BANNER"),_T("JPG"));
	m_banner.SetTexture((HBITMAP)bmp.Detach());	
	m_banner.SetFillFlag(KCSB_FILL_TEXTURE);
	m_banner.SetSize(70); //changed dlarge
	m_banner.SetTitle(_T(""));
	m_banner.SetCaption(_T(""));
	m_banner.Attach(this, KCSB_ATTACH_RIGHT);
       }	
//<<< Spike2::Prefs Side Banner [TPT]	

	Localize();
	m_SlideBar.SetFocus(); //>>> WiZaRd::SlideBar [eMule+]
	
	return bResult;
}

//>>> WiZaRd::SlideBar [eMule+]
LRESULT CPreferencesDlg::OnSlideBarSelChanged(WPARAM /*wParam*/, LPARAM /*lParam*/)
{
	int iCurrentGlobalSel = m_SlideBar.GetGlobalSelectedItem();


	SetActivePage(iCurrentGlobalSel);

	CListBoxST* pListBox = m_SlideBar.GetGroupListBox(m_SlideBar.GetSelectedGroupIndex());
	ASSERT_VALID(pListBox);

	CString strCurrentItemText;
	pListBox->GetText(pListBox->GetCurSel(), strCurrentItemText);

	CString strCurrentGroupText = m_SlideBar.GetGroupName(m_SlideBar.GetSelectedGroupIndex());
	strCurrentGroupText.Remove('&');

	CString strTitle = GetResString(IDS_EM_PREFS);
	strTitle.Remove('&');
	SetWindowText(strTitle + _T(" -> ") + strCurrentGroupText + _T(" -> ") + strCurrentItemText);

	pListBox->SetFocus();

	return TRUE;
}
//<<< WiZaRd::SlideBar [eMule+]

void CPreferencesDlg::Localize()
{
//>>> WiZaRd::SlideBar [eMule+]
	m_ImageList.DeleteImageList();
	m_ImageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 0, 1);
	m_ImageList.Add(CTempIconLoader(_T("PREFERENCES")));
	m_ImageList.Add(CTempIconLoader(_T("DISPLAY")));
	m_ImageList.Add(CTempIconLoader(_T("CONNECTION")));
	m_ImageList.Add(CTempIconLoader(_T("SERVER")));
	m_ImageList.Add(CTempIconLoader(_T("FOLDERS")));
	m_ImageList.Add(CTempIconLoader(_T("TRANSFER")));
	m_ImageList.Add(CTempIconLoader(_T("PROXY")));
	m_ImageList.Add(CTempIconLoader(_T("NOTIFICATIONS")));
	m_ImageList.Add(CTempIconLoader(_T("STATISTICS")));
	m_ImageList.Add(CTempIconLoader(_T("MESSAGE")));
	m_ImageList.Add(CTempIconLoader(_T("SECURITY")));
	m_ImageList.Add(CTempIconLoader(_T("SCHEDULER")));
	m_ImageList.Add(CTempIconLoader(_T("WEB")));
	int iTweak = m_ImageList.Add(CTempIconLoader(_T("TWEAK")));	
	m_ImageList.Add(CTempIconLoader(_T("TWEAK")));  //dlarge Missing Prefs	
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	m_ImageList.Add(CTempIconLoader(_T("PREFERENCES")));
#endif

	//dlarge Mod Pages
	int iEMF = m_ImageList.Add(CTempIconLoader(_T("SAMEMOD")));     //Tweaks 1
        m_ImageList.Add(CTempIconLoader(_T("SAMEMOD")));                //Tweaks 2 
        m_ImageList.Add(CTempIconLoader(_T("SAMEMOD")));                //Tweaks 3
	m_ImageList.Add(CTempIconLoader(_T("BACKUP")));                 //dlarge Backup
        m_ImageList.Add(CTempIconLoader(_T("VSi")));                    //dlarge Virus Scan
	m_ImageList.Add(CTempIconLoader(_T("ARGOS")));                  //dlarge Argos
	m_ImageList.Add(CTempIconLoader(_T("WEB")));			//>>> shadow2004::Updates-Prefspage
        //dlarge end

	CString title = GetResString(IDS_EM_PREFS); 
	title.Remove(_T('&')); 
	SetTitle(title); 

	m_wndGeneral.Localize();
	m_wndDisplay.Localize();
	m_wndConnection.Localize();
	m_wndServer.Localize();
	m_wndDirectories.Localize();
	m_wndFiles.Localize();
	m_wndStats.Localize();
	m_wndNotify.Localize();
	m_wndSecurity.Localize();
	m_wndTweaks.Localize();
	m_wndHiddenprefs.Localize();         //dlarge Hidden prefs
	m_wndWebServer.Localize();
	m_wndScheduler.Localize();
	m_wndProxy.Localize();
	m_wndMessages.Localize();

//dlarge Mod Pages
	m_wndeMuleFuture.Localize();    //Tweaks 1
	m_wndTweaks2.Localize();        //Tweaks 2 
        m_wndX_General.Localize();      //Tweaks 3 
	m_wndBackup.Localize();         //dlarge Backup
	m_wndVS.Localize();             //dlarge Virus Scan 
	m_wndUpdates.Localize();	//>>> shadow2004::Updates-Prefspage

//dlarge end
	int c = 0;

//>>> WiZaRd::SlideBar [eMule+]
	m_SlideBar.ResetContent();

	//basics:
	int iGroup = m_SlideBar.AddGroup(GetResString(IDS_LD_BASICOPT), 0);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_GENERAL), iGroup, c++); 
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_DISPLAY), iGroup, c++); 
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_CONNECTION), iGroup, c++); 
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_SERVER), iGroup, c++); 
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_DIR), iGroup, c++); 
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_FILES), iGroup, c++); 

	//advanced:
	iGroup = m_SlideBar.AddGroup(GetResString(IDS_LD_ADVANCEDOPT), iTweak);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_PROXY), iGroup, c++); 	
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_EKDEV_OPTIONS), iGroup, c++); 
	m_SlideBar.AddGroupItem(GetResString(IDS_STATSSETUPINFO), iGroup, c++); 
	m_SlideBar.AddGroupItem(GetResString(IDS_MESSAGESCOMMENTS), iGroup, c++); 
	m_SlideBar.AddGroupItem(GetResString(IDS_SECURITY), iGroup, c++); 
	m_SlideBar.AddGroupItem(GetResString(IDS_SCHEDULER), iGroup, c++); 
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_WS), iGroup, c++); 
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_TWEAK), iGroup, c++); 
	m_SlideBar.AddGroupItem(GetResString(IDS_X_PW_HIDDENPREFS), iGroup, c++); //dlarge Hidden prefs
	#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	m_SlideBar.AddGroupItem(_T("Debug"), iGroup, c++); 
	#endif

	//dlarge Mod Pages
	iGroup = m_SlideBar.AddGroup(MOD_VERSION,iEMF);
	m_SlideBar.AddGroupItem(_T("Silver I"), iGroup, c++);			//Tweaks 1
	m_SlideBar.AddGroupItem(_T("Silver II"), iGroup, c++);                  //Tweaks 2 
        m_SlideBar.AddGroupItem(_T("Silver III"), iGroup,c++);                  //Tweaks 3 
	m_SlideBar.AddGroupItem(GetResString(IDS_BACKUP), iGroup, c++);         //dlarge Backup
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_VS), iGroup, c++);          //dlarge Virus Scan
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_ARGOS), iGroup, c++);        //dlarge Argos
	m_SlideBar.AddGroupItem(GetResString(IDS_UPDATES), iGroup, c++);	//>>> shadow2004::Updates-Prefspage
        //dlarge end

	int width = m_SlideBar.GetGreaterStringWidth();
	width+=60;

	CRect rectOld;
	m_SlideBar.GetWindowRect(rectOld);

	int xoffset, yoffset;
	if(IsWindowVisible())
	{
		yoffset=0;
		xoffset=width-rectOld.Width();
	}
	else
	{
		xoffset=width-rectOld.Width()+10;
		GetActivePage()->GetWindowRect(rectOld);
		ScreenToClient (rectOld);
		yoffset = -rectOld.top;
	}
	GetWindowRect(rectOld);
	SetWindowPos(NULL,0,0,rectOld.Width()+xoffset,rectOld.Height()+yoffset,SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
	CTabCtrl* tab = GetTabControl(); 
	tab->GetWindowRect (rectOld);
	ScreenToClient (rectOld);
	tab->SetWindowPos(NULL,rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
	CPropertyPage* activepage = GetActivePage();
	activepage->GetWindowRect(rectOld);
	ScreenToClient (rectOld);
	activepage->SetWindowPos(NULL,rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
	GetClientRect(rectOld);
	m_SlideBar.SetWindowPos(NULL, 6, 6, width, rectOld.Height() - 12, SWP_NOZORDER | SWP_NOACTIVATE);
	int _PropSheetButtons[] = {IDOK, IDCANCEL, ID_APPLY_NOW, IDHELP };
	CWnd* PropSheetButton;
	for (int i = 0; i < sizeof (_PropSheetButtons) / sizeof(_PropSheetButtons[0]); i++)
	{
		if ((PropSheetButton = GetDlgItem(_PropSheetButtons[i])) != NULL)
		{
			PropSheetButton->GetWindowRect (rectOld);
			ScreenToClient (rectOld);
			PropSheetButton->SetWindowPos (NULL, rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
		}
	}
	tab->ShowWindow(SW_HIDE);

	m_SlideBar.SelectGlobalItem(m_nActiveWnd);
	OnSlideBarSelChanged(NULL, NULL); 
 	CenterWindow();
	m_banner.UpdateSize(); //>>> Spike2::Prefs Side Banner [TPT]
	Invalidate();
	RedrawWindow();
}
